/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class main {
    public static Card[] cards = new Card[52];
    public static JFrame frame;
    public static JPanel gamePanel;
    public static JButton hitButton;
    public static JButton stayButton;

    public static void window() {
        frame = new JFrame("Black Jack by Lenny");
        frame.setSize(600, 500);
        frame.setDefaultCloseOperation(3);
        frame.setLocationRelativeTo(null);
        frame.setResizable(false);
        URL uRL = main.class.getResource("/cards/spades.png");
        frame.setIconImage(new ImageIcon(uRL).getImage());
        gamePanel = new JPanel(){

            @Override
            public void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                main.draw(graphics);
            }
        };
        gamePanel.setBackground(new Color(33, 156, 70));
        gamePanel.setLayout(null);
        hitButton = new JButton("Hit"){

            @Override
            protected void paintComponent(Graphics graphics) {
                Graphics2D graphics2D = (Graphics2D)graphics.create();
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.setColor(this.getBackground());
                graphics2D.fillRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, 24, 24);
                graphics2D.dispose();
                super.paintComponent(graphics);
            }
        };
        hitButton.setBounds(150, 400, 120, 36);
        hitButton.addActionListener(actionEvent -> main.hit());
        hitButton.setContentAreaFilled(false);
        hitButton.setBorderPainted(false);
        hitButton.setBackground(new Color(0, 0, 0));
        hitButton.setForeground(new Color(255, 255, 255));
        hitButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                hitButton.setBackground(new Color(50, 50, 50));
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                hitButton.setBackground(new Color(0, 0, 0));
            }
        });
        hitButton.setCursor(new Cursor(12));
        hitButton.setEnabled(false);
        gamePanel.add(hitButton);
        stayButton = new JButton("Stay"){

            @Override
            protected void paintComponent(Graphics graphics) {
                Graphics2D graphics2D = (Graphics2D)graphics.create();
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.setColor(this.getBackground());
                graphics2D.fillRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, 24, 24);
                graphics2D.dispose();
                super.paintComponent(graphics);
            }
        };
        stayButton.setBounds(350, 400, 120, 36);
        stayButton.addActionListener(actionEvent -> main.stay());
        stayButton.setContentAreaFilled(false);
        stayButton.setBorderPainted(false);
        stayButton.setBackground(new Color(0, 0, 0));
        stayButton.setForeground(new Color(255, 255, 255));
        stayButton.setCursor(new Cursor(12));
        stayButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                stayButton.setBackground(new Color(50, 50, 50));
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                stayButton.setBackground(new Color(0, 0, 0));
            }
        });
        stayButton.setEnabled(false);
        gamePanel.add(stayButton);
        frame.add(gamePanel);
        frame.setVisible(true);
        main.handOutFirstCards();
    }

    public static void draw(Graphics graphics) {
        int n = 0;
        int n2 = 0;
        block8: for (int i = 0; i < cards.length; ++i) {
            if (cards[i] == null) continue;
            BufferedImage bufferedImage = main.cards[i].image;
            switch (main.cards[i].owner) {
                case "player": {
                    graphics.drawImage(bufferedImage, 50 + 120 * n, 220, 100, 141, gamePanel);
                    ++n;
                    continue block8;
                }
                case "dealer": {
                    graphics.drawImage(bufferedImage, 50 + 120 * n2, 40, 100, 141, gamePanel);
                    ++n2;
                }
            }
        }
    }

    public static void hit() {
        for (int i = 0; i < cards.length; ++i) {
            Card card;
            if (cards[i] != null) continue;
            main.cards[i] = card = new Card("player");
            gamePanel.repaint();
            main.checkBustOrBlackjack();
            break;
        }
    }

    public static void checkBustOrBlackjack() {
        if (main.getPoints("player") > 21) {
            hitButton.setEnabled(false);
            stayButton.setEnabled(false);
            Timer timer = new Timer();
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(frame, "You busted! Dealer wins.");
                    main.reset();
                }
            }, 1000L);
        }
        if (main.getPoints("player") == 21) {
            hitButton.setEnabled(false);
        }
    }

    public static void stay() {
        hitButton.setEnabled(false);
        stayButton.setEnabled(false);
        main.dealer();
    }

    public static void dealer() {
        final Timer timer = new Timer();
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                if (main.getPoints("dealer") > 16) {
                    main.getWinner();
                    timer.cancel();
                    return;
                }
                main.dealerHit();
            }
        };
        timer.scheduleAtFixedRate(timerTask, 1000L, 1000L);
    }

    public static void dealerHit() {
        Card card = new Card("dealer");
        for (int i = 0; i < cards.length; ++i) {
            if (cards[i] != null) continue;
            main.cards[i] = card;
            gamePanel.repaint();
            break;
        }
    }

    public static void getWinner() {
        int n = main.getPoints("player");
        int n2 = main.getPoints("dealer");
        Object object = "";
        object = n > 21 && n2 > 21 ? "no one" : (n > 21 ? "dealer" : (n2 > 21 ? "player" : (n > n2 ? "player" : (n2 > n ? "dealer" : (n2 == n && n2 == 21 ? "no one (two blackjacks)" : "idk, here are the points - player: " + n + ", dealer: " + n2)))));
        JOptionPane.showMessageDialog(frame, "The winner is: " + (String)object);
        main.reset();
    }

    public static void reset() {
        cards = new Card[52];
        gamePanel.repaint();
        hitButton.setEnabled(false);
        stayButton.setEnabled(false);
        main.handOutFirstCards();
    }

    public static int getPoints(String string) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < cards.length; ++i) {
            if (cards[i] == null || !main.cards[i].owner.equals(string)) continue;
            if (main.cards[i].value == 11) {
                ++n2;
                continue;
            }
            n += main.cards[i].value;
        }
        switch (n2) {
            case 0: {
                return n;
            }
            case 1: {
                if (n + 11 > 21) {
                    return n + 1;
                }
                return n + 11;
            }
            case 2: {
                if (n + 12 > 21) {
                    return n + 2;
                }
                return n + 12;
            }
            case 3: {
                if (n + 13 > 21) {
                    return n + 3;
                }
                return n + 13;
            }
            case 4: {
                if (n + 14 > 21) {
                    return n + 4;
                }
                return n + 14;
            }
        }
        return 502;
    }

    public static void handOutFirstCards() {
        final Timer timer = new Timer();
        TimerTask timerTask = new TimerTask(){
            private int cardIndex = 0;

            @Override
            public void run() {
                switch (this.cardIndex) {
                    case 0: {
                        main.cards[this.cardIndex] = new Card("player");
                        break;
                    }
                    case 1: {
                        main.cards[this.cardIndex] = new Card("dealer");
                        break;
                    }
                    case 2: {
                        main.cards[this.cardIndex] = new Card("player");
                        hitButton.setEnabled(true);
                        stayButton.setEnabled(true);
                        main.checkBustOrBlackjack();
                        timer.cancel();
                    }
                }
                gamePanel.repaint();
                ++this.cardIndex;
            }
        };
        timer.scheduleAtFixedRate(timerTask, 500L, 1000L);
    }

    public static int getCardCount(String string) {
        int n = 0;
        for (int i = 0; i < cards.length; ++i) {
            if (cards[i] == null || !main.cards[i].owner.equals(string)) continue;
            ++n;
        }
        return n;
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(() -> main.window());
    }
}

